#ifndef __COMPILER_SPEC_H
#define __COMPILER_SPEC_H

#include <stdint.h>   /* ISO C: uint8_t/uint16_t/uint32_t definitions */
#include <stdbool.h>  /* ISO C: "bool" definition */

#ifndef FALSE
#define FALSE false
#endif

#ifndef TRUE
#define TRUE true
#endif

#ifndef NULL
#define NULL (0)
#endif

typedef unsigned int IRQSTATE;

#ifdef __ARM_COMPILER__
  #ifndef INTERRUPT
  #define INTERRUPT __irq
  #endif
  #ifndef __PACKED_PRE
  #define __PACKED_PRE __packed
  #endif
  #ifndef __PACKED_POST
  #define __PACKED_POST
  #endif
#else
  #ifndef INTERRUPT
  #define INTERRUPT __attribute__ ((interrupt ("IRQ")))
  #endif
  #ifndef __PACKED_PRE
  #define __PACKED_PRE
  #endif
  #ifndef __PACKED_POST
  #define	__PACKED_POST __attribute__((packed))
  #endif
#endif

/* Byte swap operations */
#ifndef htons
#define htons(val) ((((val) & 0xff) << 8) | ((val) >> 8))
#endif
#ifndef htonl
#define htonl(val) ((((val) & 0xff) << 24) | (((val) & 0xff00) << 8) | (((val) & 0xff0000) >> 8 ) | ((val) >> 24))
#endif
#ifndef ntohs
#define ntohs(val) htons(val)
#endif
#ifndef ntohl
#define ntohl(val) htonl(val)
#endif

#endif /* __COMPILER_SPEC_H */
